/************************************************************************
 * TITLE:         CONVIDEO.S            				*
 * PROJECT:	  JAGUAR MC   						*
 * FUNCTION:      Console Video Driver 					*
 * PROGRAMMER:    Hans-Martin Krober					*
 * DATE:       	  12/95              					*
 *                         						*
 *            COPYRIGHT 1993,1994,1995 Atari U.S. Corporation           *
 *          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
 *          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
 *        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
 *                          ALL RIGHTS RESERVED.                        *
 *                         						*
 ************************************************************************/

#include "portab.h"
#include "blit.h"
#include "font.h"
#inculde "_vdi.h"
#inculde "scrndef.h"


#define SCREEN_W 320
#define WIDFLAG WID320		/* blitter flags corresponding to OBJWIDTH */
#define LINEY 12		/* number of pixels per line of characters */

/************************************************************************
 *									*
 *	EXTERNAL DATA							*	
 ***                                                                  ***/

EXTERN BYTE	v_screen[];		/* Main video screen buffer 	*/
EXTERN FNThead 	sysfnt[];		/* System font header		*


/************************************************************************
 *									*
 *	GLOBAL DATA							*	
 ***                                                                  ***/

GLOBAL BYTE cv_curs_x;			/* Console Driver X cursor pos	*/
GLOBAL BYTE cv_curs_y;			/* Console Driver Y cursor pos	*/
GLOBAL BYTE cv_buf[2];			/* Console Driver Oubuf buffer	*/

GLOBAL WORD gl_wchar;			/* Width of System Font Char	*/
GLOBAL WORD gl_hchar;			/* Height of System Font Char	*/


/************************************************************************
 *									*
 *	FUNCTIONS							*	
 ***                                                                  ***/


/*
 *	:v_init()
 *	Initialized the Video Output Driver
 */

	GLOBAL WORD
v_init(VOID)
{
	v_handle 	= 0;
	v_scrn_id 	= 0
	return 0;
}

/*
 *	:v_crtvwk()
 *	Create a virtual workstation
 */

	GLOBAL WORD
v_crtvwk(name, screen, planes, width, height)
	BYTE	*name;
	BYTE	*screen;
	WORD	planes;
	WORD	width;
	WORD	height;
{
	SCREENDEF *s = &v_screen[v_scrn_id];

	s->name 	= name;
	s->devId	= v_scrn_id;
	s->planes	= planes;
	s->xRez		= width;
	s->yRez		= height;
	s->formId	= PIXPACKED;
	s->vidAdr	= screen;

	return v_scrn_id++;
}


/*
 *	:vc_conout()
 *	Print a character on the screen
 */

	WORD
vc_conout(handle, c)
	WORD handle;
	WORD c;
{
	VWRKSTN p_vwk = &v_vwk[handle];

	switch (c) {
	case CR:
		p_vwk->vc_curs_x  = 0;
		p_vwk->vc_curs_y  += p_vwk->vc_hchar;
		break;
	default:
		p_vwk->vc_outbuf[0] = c;

		FNTstr(curs_x, curs_y, outbuf, 
		mscreen, PIXEL16|PITCH1|WIDFLAG, sysfnt, 0x1aff, 0 );

		curs_x += gl_wchar;

		if (curs_x > (cv_/6*6)) {
			curs_x  = 0;
			curs_y += gl_hchar;
		}
		break;
	}
}
