;************************************************************************
;* TITLE:         STARTUP.S            *
;* PROJECT:    JAGUAR               *
;* FUNCTION:      STARTUP CODE            *
;* PROGRAMMER:    Hans-Martin Krober         *
;* DATE:       1/95              *
;*                         *
;* NOTE:          Link this file <<<< FIRST >>>>      *
;*                         *
;*            COPYRIGHT 1993,1994,1995 Atari U.S. Corporation           *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                         *
;************************************************************************

#define VIDEO  1

;*======================================================================*
;* INCLUDE FILES
;*======================================================================*
   include "jaguar.inc"


;*======================================================================*
;* EXTERNAL SYMBOLS
;*======================================================================*

   .extern _wrkbJlist      ; object proc. list
   .extern _orgbJlist      ; object proc. list
   .extern _memflag     ; memory init flag
   .extern __levels

;*======================================================================*
;* EXTERNAL ROUTINES
;*======================================================================*
   .extern  _color_setup

   .extern  _init_alloc
   .extern  _init_objs
   .extern  IntInit
   .extern  VideoIni
   .extern  _ClearScrn
   .extern  bscdraw_gpu
   .extern  __txtblt_init
   .extern __slibcinit

   .extern _v_dflt_bg

   .extern  _init_synth
   .extern  __init_midi
   .extern  _init_parse

   .extern _jazmain
   .extern mouse_int
   .extern _memcpy
   .extern _v_draw_title
   .extern  _video_off
;*======================================================================*
;* PUBLIC SYMBOLS
;*======================================================================*

   .globl   _v_bas_ad
   .globl   _scrn_w
   .globl   _scrn_h

   .globl   MainScreen
   .globl _mousex
   .globl _mousey
   .globl _hogscale
   .globl _hog_on
   .globl _mousebutt
   .globl _joyvalues
   .globl _vbi_count
   .globl __dsp_idle
   .globl stopobj
   .globl _errno
   .globl _title_screen
   .globl _dram_fuji

;*======================================================================*
;* PUBLIC ROUTINES
;*======================================================================*

   .globl   startup


;*======================================================================*
;* LOCAL EQUATES
;*======================================================================*

   BLUEXXX         equ     $07E807E8

;*======================================================================*
;* TEXT AREA
;*======================================================================*

   .text

;*======================================================================*
;* startup - Link this file ************** FIRST ***************
;*======================================================================*
startup:

;  Run the GPU/BLIT interface in CORRECT mode ALWAYS

   move.l   #$00070007,G_END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; At this point we don't know what state the video is in.
; It may be active or not and may be using an interrupt or not.
;
; Since we may not turn video off we use the following procedure:
;
; 1) Disable VI by setting to a VERY large number.  The existing
;    screen will fail to be refreshed so all bit maps vanish.
; 2) Set up an object list consisting of a stop object.
; 3) Clear the bitmap object's memory
; 4) Set up the desired object list
; 5) Set up an interrupt and start
; 6) Set up the size of borders
; 7) Point the Object Processor at the real object list
; 8) Set VMODE to the desired resolution and color model
;
; NOTE: To blank the screen point the object processor at a stop object
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;***  Init the stack
   move.l   #STack,a7
if VIDEO
;***  Set up object processor to SAFE stop object!!!!
   move.l   #0,stopobj
   move.l   #4,stopobj+4
   move.l   #stopobj,d0
   swap  d0
   move.l   d0,OLP
endif
;***  Set up screen memory
   move.l   #MainScreen, _v_bas_ad

;***  Init Memory Alloc
   move.w   #0, _memflag
   jsr   _init_alloc
if VIDEO
;***  Init Object Processor objects, Video, Horiz. Blank IRQ
   move.l   #0, _vbi_count

   move.l   #39360,-(sp)
   move.l   #fuji,-(sp)
   move.l   #_dram_fuji,-(sp)
   jsr _memcpy
   add.l #12,sp

   jsr   _init_objs
   jsr   VideoIni
   jsr   IntInit

   move.l   _wrkbJlist,d0     ; this is our object list pointer
   swap  d0
   move.l   d0, OLP        ; give it to the object proc.

   add.l #16, _wrkbJlist      ; we only need to update the screen obj
   add.l #16, _orgbJlist      ; so lets skip the two branch objs

   move.l   #$00070007,G_END  ; Set good mode (again)

   move.w   #$4C7,VMODE    ; Set 16 bit RGB
               ; 384 pixel-wide overscanned

;***  Clear Screen
;  move.l   #BLUEXXX, -(a7)
;  jsr   _ClearScrn
;  addq.l   #4,a7
else
   move.w   #0,INT1
endif


;***  Init Basic Drawing Routines & TxtBlt
   jsr   bscdraw_gpu
   move.l   _v_bas_ad, -(a7)
   jsr   __txtblt_init
   addq.l   #4, a7

   jsr   __slibcinit

;; jsr   _color_setup

;; jsr   _v_dflt_bg     ; draw a nice background
   jsr   _v_draw_title

;***  Init the Synth
;;   jsr   _init_synth	; moved to main()

;***  Init the MIDI IRQ
;;   jsr   __init_midi	; moved to main()

;;   jsr   _init_parse	; move to main()

;***    Init mouse and joypad variables
   move.l  #192,_mousex
   move.l  #160,_mousey
   move.l   #-1,_joyvalues
   move.l   #-1,_joyvalues+4
   move.l   #-1,_joyvalues+8
   move.l   #-1,_joyvalues+12
   move.l   #0,__levels
   move.l   #$0f0f0f,_hogscale
   move.l   #0,_hog_on

;;jsr _video_off

;***  Go to the mother of all functions & never come back !!!
   jsr   _jazmain

   illegal


;*======================================================================*
;* LOCAL RAM
;*======================================================================*

   .data
_scrn_w:
   .dc.w    384      ; Width of screen
_scrn_h:
   .dc.w    200      ; Height of screen

tsttxt:
   .dc.b    "Hello Paul!"

   .long
_title_screen:
   .include "jaz.rgb"
   .long
fujilogo:
   .include "fuji.rgb"
   .long
stemp_end:

   .bss
   .phrase
_hog_on:
      .ds.l 1
_hogscale:
      .ds.l 1
_mousex:
      .ds.l 1
_mousey:
      .ds.l 1
_joyvalues:
      .ds.l 4
_mousebutt:
      .ds.l 1
_vbi_count:
      .ds.l 1
__dsp_idle:
      .ds.l 1
_errno:
      .ds.l 1

d1dummy:
   .ds.w 8        ; Protection against overwrites
   .phrase
MainScreen:
   .ds.b 160000         ; memory for the screen

_dram_fuji:
   .ds.b 40000

  .ds.l 4000

STack:   .ds.l 1        ; our stack

_v_bas_ad:
   .ds.l 1        ; Screen pointer

   .phrase
stopobj:
   .ds.l 2

   .phrase
   .end


;*======================================================================*
;*          EOF
;*======================================================================*
