;************************************************************************
;*	TITLE:			INTSERV.S				*
;*	PROJECT:		JAGUAR					*
;*	FUNCTION:		INTERRUPT SERVICE			*
;*	PROGRAMMER:							* 
;*	DATE:			4/94					*
;*									*
;*              COPYRIGHT 1993,1994 Atari U.S. Corporation              *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*									*
;************************************************************************

	.include	'jaguar.inc'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.globl	IntInit

	.extern	a_vde
	.extern	_sizeJlist
	.extern _orgbJlist
	.extern _wrkbJlist

	.extern _memcpy

	.extern	_parser
	.extern	__readpad
	.extern _alloc

	.extern	_play_midi
	.extern	play_flag
	.extern get_midi
	.extern _mousex
	.extern _mousey
	.extern _hogscale
	.extern _hog_on
	.extern mouse_int
	.extern _vbi_count
	.extern	stopobj

	.globl	_video_on
	.globl	_video_off

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;USER0	equ	4*$40

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; This will set up the VI (Vertical line counter Interrupt)

IntInit:
.if 0
	move.l	#Frame, a0			; copy irq routine to RAM
	move.l	#Frame_end, d1
	sub.l	a0, d1

	movem.l	a0/d1, -(sp)
	move.l	d1, -(sp)
	jsr	_alloc				; get RAM
	addq.l	#4, sp
	movem.l	(sp)+, a0/d1	
	move.l	d0, a1
	move.l	d0, a2
	lsr.l	#2, d1
	subq.l	#1, d1
cpy_video:
	move.l	(a0)+, (a1)+
	dbra	d1, cpy_video

	move.l	a2,USER0		; Set up the vector
.else
	move.l	#Frame,USER0		; Set up the vector
.endif
	move.w	a_vde,d0
	or.w	#1,d0
	move.w	d0,VI			; Get the maximum VBLANK time

	move.w	#1,INT1

	move.w	sr,d0
	and.w	#$f8ff,d0		; Lower the 68K IPL
	move.w	d0,sr
	move.w	#1, video_flag
	rts

_video_on:
	move.l	_wrkbJlist,d0		; this is our object list pointer
	sub.l	#16,d0			; get to the first objc.
	swap	d0
	move.l	d0, OLP			; give it to the object proc.
	move.w	#1, video_flag
	rts

_video_off:
	move.l	#stopobj,d0
	swap	d0
	move.l	d0,OLP	
	move.w	#0, video_flag		
	rts
  


Frame:
	movem.l	d0-d3/a0-a2,-(sp)

	addq.l	#1,_vbi_count

	move.w	video_flag, d0
	cmp.w	#0, d0
	beq	xxle

;***	copy (restore) object list
	move.l	_orgbJlist, a0		; here's the screen object
	move.l	_wrkbJlist, a1	

	move.l	(a0)+,d1		; copy first phrase screen
	move.l	(a0)+,d2
	move.l	d1,(a1)+
	move.l	d2,(a1)+

	addq.l	#8,a1			; skip second phrase
	addq.l	#8,a0
	move.l	a1,a2			; save for later
	move.l	(a0)+,d1		; copy first phrase mouse
	move.l	(a0)+,d2
	move.l	d1,(a1)+
	move.l	d2,(a1)+

	add.l	#24,a1			; skip 4th phrase
	add.l	#24,a0
	cmp.l	#1,_hog_on
	beq		do_hog
	move.l	#0,(a1)+
	move.l	#4,(a1)+
	jmp		do_mouse
do_hog:
	move.l	(a0)+,d1		; copy first phrase mouse
	move.l	(a0)+,d2
	move.l	d1,(a1)+
	move.l	d2,(a1)+

	add.l	#12,a1
	move.l	_hogscale,(a1)

do_mouse:
	addq.l	#4,a2			; skip first long
	
	move.l  _mousey,d0		; load ypos
	move.l  (a2),d1
	and.l	#$ffffc007,d1
	lsl.l	#3,d0
	and.l	#$3ff8,d0
	or.l	d0,d1
	move.l	d1,(a2)+		; and write back

	addq.l	#4,a2
	move.l  _mousex,d0		; load xpos
	move.l	(a2),d1
	and.l	#$fffff000,d1
	and.l	#$fff,d0
	or.l	d0,d1
	move.l	d1,(a2)			; and write back	


;	// new way
xxle:
	move.w	#$101,INT1
	move.w	#0,INT2	
	movem.l	(sp)+,d0-d3/a0-a2
	rte
	nop
	nop
	nop
	nop
Frame_end:
	.phrase	; Force object code size alignment

	.bss
video_flag:
	.ds.w	1
