#include "olist.h"
#include "font.h"
#include "blit.h"
#include "joypad.h"

#if 0
#define BIT_1 /* define this for a 1 bit per pixel display */
#endif

#define DATA16 (void *)0xa0000

long packed_olist[160];

/* 1 320x200 object */
union olist default_olist[2] =
{
	{OL_BITMAP,		/* type */
	 0, 40,		/* x, y */
	 0L,			/* link */
	 DATA16,	/* data */
#ifndef BIT_1
	 200, 320/4, 320/4,		/* height, dwidth, iwidth */
	 4, 1, 0, OL_TRANS, 0,	/* depth, pitch, index, flags, firstpix */
#else
	 200, 320/64, 320/64,		/* height, dwidth, iwidth */
	 0, 1, 0, 0, 0,	/* depth, pitch, index, flags, firstpix */
#endif
	 0,0,0},		/* scaling stuff */

	{OL_STOP}
};

extern FNThead charb10[], charr10[], clr6x12[],
	courr08[], courr10[], courr12[],
	crill10[], crill12[],
	helvb10[], helvr08[], helvr10[], helvr12[],
	lubr10[], 
	lubs08[], lubs10[], lubs12[],
	lurs08[], lurs10[], lurs12[], lurs14[],
	lutrs08[], lutrs10[],
	ncenb08[], ncenr08[], ncenr10[],
	pd6x10[], techb14[],
	ter7x14[],
	timb08[], timr08[], timr10[],
	utrg10[],
	creed12[], creed14[], diode12[], tng9[], tng12[], tng14[],
	fnt16x8[],
	utopiar[];

struct dispfont {
	char *fntname;
	FNThead *font;
} testfont[] = {
	"HOVERSTRIKE", fnt16x8,

	"Bitstream Charter Bold 10", charb10,
	"Bitstream Charter 10", charr10,

	"Clear 6x12", clr6x12,

	"Courier 8", courr08,
	"Courier 10", courr10,
	"Courier 12", courr12,

	"Crillee 10", crill10,
	"Crillee 12", crill12,

	"Helvetica Bold 10", helvb10,
	"Helvetica 8", helvr08,
	"Helvetica 10", helvr10,
	"Helvetica 12", helvr12,

	"Lucida Bright 10", lubr10,

	"Lucida Sans Bold 8", lubs08,
	"Lucida Sans Bold 10", lubs10,
	"Lucida Sans Bold 12", lubs12,

	"Lucida Sans 8", lurs08,
	"Lucida Sans 10", lurs10,
	"Lucida Sans 12", lurs12,
	"Lucida Sans 14", lurs14,

	"New Century Bold 8", ncenb08,
	"New Century 8", ncenr08,
	"New Century 10", ncenr10,

	"PD 6x10 font", pd6x10,
	"TECH BOLD", techb14,
	"Terminal 7x14", ter7x14,

	"Times Bold 8", timb08,
	"Times Roman 8", timr08,
	"Times Roman 10", timr10,

	"Utopia 10", utrg10,
	"Type 1 Utopia 10", utopiar,

	"Creedmore 12", creed12,
	"Creedmore 14", creed14,
	"Diode 12", diode12,
	"Trek 9", tng9,
	"Trek 12", tng12,
	"Trek 14", tng14
};

#define NUMFONTS (sizeof(testfont)/sizeof(struct dispfont))

char *line1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
char *line2 = "abcdefghijklmnopqrstuvwxyz";
char *line3 = "0123456789";
char *line4 = "!@#$%^&*.'?,;";
char line5[80];

#define SCRNWIDTH 320

void
centerprint( int ypos, char *text, FNThead *font, int color )
{
	int width, xpos;

	width = FNTbox(text, font) & 0x0000ffff;
	while (width > SCRNWIDTH) {
		text++;
		width = FNTbox(text, font) & 0x0000ffff;
	}
	xpos = (SCRNWIDTH-width)/2;

#ifndef BIT_1
	FNTstr(xpos, ypos, text, DATA16, WID320|PITCH1|PIXEL16, font, color, 0);
#else
	FNTstr(xpos, ypos, text, DATA16, WID320|PITCH1|PIXEL1, font, color, 0);
#endif
}

char buf[80];

int
main()
{
	int i;
	int curfnt;
	long buts;			/* which buttons have changed */
	long butdown;			/* which buttons are down */
	int ypos, height;
	unsigned int fgcolor;
	unsigned int fgintense;
	unsigned int bgcolor;
	unsigned int bgintense;
	unsigned int color;

	extern volatile long _timestamp;

	OLbldto(default_olist, packed_olist);
	OLPset(packed_olist);
	VIDon(0x6c1);			/* 0x6c1 = CRY; 0x6c7 = RGB */


	for (i = 0; i < 31; i++)
		line5[i] = (unsigned char) i+160;
	line5[31] = 0;

	curfnt = 0;
	bgcolor = 0x78;
	bgintense = 0;
	fgcolor = 0x78;
	fgintense = 0xe0;

	for(;;) {
		VIDsync();

	/* zero the screen */
		memzero( DATA16, 320L*200L*2L );

	/* set up the background color */
		color = (bgcolor << 8)|bgintense;
		*((volatile unsigned short *)0xf00058) = color;

		sprintf(buf, "BG:%04x", color);
		FNTstr(240, 160, buf, DATA16, WID320|PITCH1|PIXEL16, clr6x12, 0x7800, 0x7890);

	/* set the foreground color */
		color = (fgcolor << 8)|fgintense;
		sprintf(buf, "FG:%04x", color);
		FNTstr(240, 173, buf, DATA16, WID320|PITCH1|PIXEL16, clr6x12, 0x7800, 0x7890);


	/* now blit some stuff */
		height = FNTbox( line1, testfont[curfnt].font ) >> 16;
		ypos = 40;

		centerprint(ypos, testfont[curfnt].fntname, testfont[curfnt].font, 0x0f9f);
		ypos += height;
		ypos += height;

		centerprint(ypos, line1, testfont[curfnt].font, color);
		ypos += height;
		centerprint(ypos, line2, testfont[curfnt].font, color);
		ypos += height;
		centerprint(ypos, line3, testfont[curfnt].font, color);
		ypos += height;
		centerprint(ypos, line4, testfont[curfnt].font, color);
#if 0
		ypos += height;
		centerprint(ypos, line5, testfont[curfnt].font, color);
#endif

		do {
			VIDsync();
			butdown = JOYget(JOY1);
			buts = JOYedge(JOY1);
		} while ( (buts == 0) && (butdown&(JOY_UP|JOY_DOWN|JOY_RIGHT|JOY_LEFT)) == 0);

		if (butdown & JOY_UP) {
			if (butdown & OPTION)
				bgintense = (bgintense+2) & 0xff;
			else
				fgintense = (fgintense+2) & 0xff;
		} else if (butdown & JOY_DOWN) {
			if (butdown & OPTION)
				bgintense = (bgintense-2) & 0xff;
			else
				fgintense = (fgintense-2) & 0xff;
		} else if (butdown & JOY_LEFT) {
			if (butdown & OPTION)
				bgcolor = (bgcolor-1) & 0xff;
			else
				fgcolor = (fgcolor-1) & 0xff;
		} else if (butdown & JOY_RIGHT) {
			if (butdown & OPTION)
				bgcolor = (bgcolor+1) & 0xff;
			else
				fgcolor = (fgcolor+1) & 0xff;

		} else if (buts & FIRE_C) {
			curfnt--;
			if (curfnt < 0) curfnt = NUMFONTS-1;
		} else if (buts & FIRE_A) {
			curfnt++;
			if (curfnt >= NUMFONTS) curfnt = 0;
		} else {
			if (buts & KEY_1)
				curfnt = 0;
			else if (buts & KEY_2)
				curfnt = 1;
			else if (buts & KEY_3)
				curfnt = 2;
			else if (buts & KEY_4)
				curfnt = 3;
			else if (buts & KEY_5)
				curfnt = 4;
			else if (buts & KEY_6)
				curfnt = 5;
			else if (buts & KEY_7)
				curfnt = 6;
			else if (buts & KEY_8)
				curfnt = 7;
			else if (buts & KEY_9)
				curfnt = 8;
			else if (buts & KEY_9)
				curfnt = 8;
			else if (buts & KEY_S)
				curfnt = 9;
			else if (buts & KEY_0)
				curfnt = 10;
			else if (buts & KEY_H)
				curfnt = 11;
		}
	}
	return 0;
}
