;************************************************************************
;* TITLE:         CONSOLE.S            					*
;* PROJECT:	  JAGUAR MC   						*
;* FUNCTION:      STARTUP CODE       					*
;* PROGRAMMER:    Hans-Martin Krober					*
;* DATE:       	  11/95              					*
;*                         						*
;*                         						*
;*            COPYRIGHT 1993,1994,1995 Atari U.S. Corporation           *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                          ALL RIGHTS RESERVED.                        *
;*                         						*
;************************************************************************

;************************************************************************

	.extern	_crt_getkbd
	.extern	_crt_getaux
	.extern	_crt_putaux
	.extern	_crt_kbdstat
	.extern	_crt_auxstat
	.extern	_v_conout

	.globl	_Bconstat
	.globl	_Bconout
	.globl	_Bconin

;************************************************************************



_Bconstat:
	move.l	a0,-(a7)	; save registers
	clr.l	d0
	move.w	4+4(a7),d0	; get device
	lsl.l	#2,d0		; long aligned	
	lea	_constat_tab, a0 ; device table
	add.l	d0, a0
	move.l	(a0),a0		; get device dependant fct
	jsr	(a0)		; do it!
	move.l	(a7)+,a0	; restore registers
 	rts

_Bconin:
	move.l	a0,-(a7)	; save registers
	clr.l	d0
	move.w	4+4(a7),d0	; get device
	lsl.l	#2,d0		; long aligned	
	lea	_conin_tab, a0 ; device table
	add.l	d0, a0
	move.l	(a0),a0		; get device dependant fct
	jsr	(a0)		; do it!
	move.l	(a7)+,a0	; restore registers
 	rts

_Bconout:
	move.l	a0,-(a7)	; save registers
	clr.l	d0
	move.w	4+4(a7),d0	; get device
	lsl.l	#2,d0		; long aligned	
	lea	_conout_tab, a0 ; device table
	add.l	d0, a0
	move.l	(a0),a0		; get device dependant fct
	move.w	4+6(a7),-(a7)	; character to output
	jsr	(a0)		; do it!
	addq.l	#2,a7
	move.l	(a7)+,a0	; restore registers
 	rts
	
nofct:
	moveq.l	#0,d0
	rts

;************************************************************************

	.data
_constat_tab:
	.dc.l	nofct
	.dc.l	_crt_auxstat		; Aux
	.dc.l	_crt_kbdstat		; Console
	.dc.l	nofct

_conin_tab:
	.dc.l	nofct
	.dc.l	_crt_getaux		; Aux 
	.dc.l	_crt_getkbd		; Console
	.dc.l	nofct

_conout_tab:
	.dc.l	nofct
	.dc.l	_crt_putaux		; Aux
	.dc.l	_v_conout		; Console
	.dc.l	nofct


