;-----------------------------------------------------------------------
;
;	blit.s
;
; Various 68000 blitter driving functions.
;
; BLTrect(void *dst_addr, long dst_flags, int x, int y, int w, int h, int color)
; blit a rectangle to a (phrase aligned) memory region; always done in
; phrase mode
;-----------------------------------------------------------------------

	.include	'jaguar.inc'
	.include	'blit.inc'

;-----------------------------------------------------------------------

_BLTrect::
	lea	4(a7),a0		; get a pointer to the argument list
	move.l	d2,-(sp)		; save reggies

.if 1
; wait for the blitter to finish
; this is probably redundant, the 68K has a lower
; bus priority anyways!

.01:
	move.l	B_CMD,d0
	btst.l	#0,d0
	beq	.01
.endif

	move.l	(a0)+,A1_BASE		; set destination address
	move.l	(a0)+,d0		; get destination flags
	and.l	#$FFF0FFFF,d0		; mask out X add control bits
	move.l	d0,A1_FLAGS		; we would 'or' in XADDPHR, if it were non-zero

; Set the coordinates of the top left corner
	move.l	(a0)+,d0		; get rectangle y,x
	swap	d0
	move.l	d0,A1_PIXEL		;get rectangle Y,X

; Set fractional pixel pointer
	move.l	#0,A1_FPIXEL
	
	move.l	(a0)+,d1		; get rectangle width,height
	swap	d1			; change it to height,width

;
; Set up the step size in x; note that this will have to reflect the phrase mode blit!
; The starting X coordinate is still in d0.w
; ASSUMPTION: 16 bit pixels (sigh)
;
	move.w	d0,d2				; calculate final x coordinate
	add.w	d1,d2
	addq.w	#1,d2				; find start of phrase for that coordinate
	and.w	#$FFFE,d2
	addq.w	#2,d2				; now find beginning of next phrase

	sub.w	d2,d0				; calculate (negative) distance

	swap		d0
	move.w	#1,d0				;Y step is always 1
	swap		d0
	move.l	d0,A1_STEP

; Set up the fractional step size
; 0 in X, 0 in y

	move.l	#0,A1_FSTEP

; Set up Counters register to rectangle width, height+1
; rect width, height is in d1
	move.l	d1,B_COUNT

;
; set rectangle color
;
	move.w	(a0)+,d0
	move.w	d0,d1
	swap	d0
	move.w	d1,d0				; get color in high word, too

	move.l	d0,B_PATD	
	move.l	d0,B_PATD+4

; Now Turn IT ON !!!!!!!!!!!!!
; NO SOURCE DATA
; NO OUTER LOOP
; Turn on pattern data
; Allow outer loop update

	move.l	#PATDSEL|UPDA1,d0
	move.l	d0,B_CMD

	move.l	(sp)+,d2			; restore reggies
	rts

